import 'package:flutter/material.dart';
import 'package:naim/classes/Auth.dart';
import 'package:naim/classes/appdata.dart';
import 'package:naim/classes/assets.dart';
import 'package:naim/classes/message.dart';

import '../classes/cipher.dart';

class ChatBubble extends StatefulWidget {
  @override
  ChatBubble(this.message, {this.fromWithin = false});
  _ChatBubbleState createState() => _ChatBubbleState();
  final Message message;
  bool fromWithin;
}

class _ChatBubbleState extends State<ChatBubble> {
  bool current = false;

  @override
  initState() {
    super.initState();
  }

  @override
  void setState(fn) {
    if (mounted) {
      super.setState(fn);
    }
  }

  @override
  Widget build(BuildContext context) {
    //print(widget.message.description);
    //if (widget.message.print) {
    if (widget.message.user.id.toString() == appData.dbUser["id"].toString()) {
      current = true;
    } else {
      current = false;
    }
    print("=============");
    print(decryptIt(widget.message.description, appData.strPwd));
    print(widget.message.user.id);
    print("current == $current");
    //}
    if (widget.message.type == "status") {
      return Center(
        child: Padding(
          padding: const EdgeInsets.all(10.0),
          child: Text(decryptIt(widget.message.description, appData.strPwd),
              style: const TextStyle(
                  fontSize: 14,
                  color: Colors.white,
                  shadows: <Shadow>[
                    Shadow(
                      offset: Offset(1.0, 1.0),
                      blurRadius: 1.0,
                      color: Color.fromARGB(255, 0, 0, 0),
                    )
                  ])),
        ),
      );
    } else {
      return Row(
        mainAxisAlignment:
            current ? MainAxisAlignment.end : MainAxisAlignment.start,
        crossAxisAlignment:
            current ? CrossAxisAlignment.end : CrossAxisAlignment.start,
        children: <Widget>[
          SizedBox(width: current ? 30.0 : 20.0),
          if (!current) ...[
            CircleAvatar(
              backgroundImage: NetworkImage(
                current
                    ? dataUrl + appData.dbUser["photo"]
                    : dataUrl + widget.message.user.photo,
              ),
              radius: 20.0,
            ),
            const SizedBox(width: 5.0),
          ],

          ///Chat bubbles
          Container(
            padding: const EdgeInsets.only(
              bottom: 5,
              right: 5,
            ),
            child: Column(
              crossAxisAlignment:
                  current ? CrossAxisAlignment.end : CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  constraints: BoxConstraints(
                    minHeight: 40,
                    maxHeight: 250,
                    maxWidth: MediaQuery.of(context).size.width * 0.7,
                    minWidth: MediaQuery.of(context).size.width * 0.1,
                  ),
                  decoration: BoxDecoration(
                    color: current
                        ? appColors.armyColor(context)
                        : appColors.backgroundColor(context),
                    borderRadius: current
                        ? const BorderRadius.only(
                            topLeft: Radius.circular(20),
                            bottomLeft: Radius.circular(20),
                            topRight: Radius.circular(20),
                          )
                        : const BorderRadius.only(
                            topLeft: Radius.circular(20),
                            bottomRight: Radius.circular(20),
                            topRight: Radius.circular(20),
                          ),
                  ),
                  child: Padding(
                    padding: const EdgeInsets.only(
                        left: 15, top: 10, bottom: 5, right: 5),
                    child: Column(
                      mainAxisSize: MainAxisSize.min,
                      crossAxisAlignment: current
                          ? CrossAxisAlignment.end
                          : CrossAxisAlignment.start,
                      children: <Widget>[
                        Padding(
                          padding: const EdgeInsets.only(right: 10),
                          child: Text(
                            decryptIt(
                                widget.message.description, appData.strPwd),
                            style: TextStyle(
                              color: current
                                  ? Colors.white
                                  : appColors.textColor(context),
                            ),
                          ),
                        ),
                        const Icon(
                          Icons.done_all,
                          color: Colors.white,
                          size: 14,
                        )
                      ],
                    ),
                  ),
                ),
                const SizedBox(
                  height: 2,
                ),
                Text(
                  widget.message.formatDate(),
                  style: const TextStyle(
                      fontSize: 12,
                      color: Colors.white,
                      shadows: <Shadow>[
                        Shadow(
                          offset: Offset(1.0, 1.0),
                          blurRadius: 1.0,
                          color: Color.fromARGB(255, 0, 0, 0),
                        )
                      ]),
                )
              ],
            ),
          ),
          if (current) ...[
            const SizedBox(width: 5.0),
            CircleAvatar(
              backgroundImage: NetworkImage(
                current
                    ? dataUrl + appData.dbUser["photo"]
                    : dataUrl + widget.message.user.photo,
              ),
              radius: 10.0,
            ),
          ],
          SizedBox(width: current ? 20.0 : 30.0),
        ],
      );
    }
  }
}
