import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

const String appLogo = 'assets/images/logo.png';
const String camobkimg = 'assets/images/bk.jpg';
const String lightcamobk = 'assets/images/ligth_bk.jpg';
const String darkcamobk = 'assets/images/dark_bk.jpg';

const Color armyGreen = Color(0xFF4B5320);

const List<String> avatars = [
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2F1.jpg?alt=media',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2F4.jpg?alt=media',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2F6.jpg?alt=media',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2F7.jpg?alt=media',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2Fdev_damodar.jpg?alt=media&token=aaf47b41-3485-4bab-bcb6-2e472b9afee6',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2Fdev_sudip.jpg?alt=media',
  'https://firebasestorage.googleapis.com/v0/b/dl-flutter-ui-challenges.appspot.com/o/img%2Fdev_sid.png?alt=media',
];

class appColors {
  static Color backgroundColor(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Color(0xFF363846)
        : Color(0xFFf2f2f0);
  }

  static Color backgroundColor2(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Color.fromARGB(255, 30, 31, 37)
        : Color.fromARGB(255, 209, 209, 209);
  }

  static Color armyColor(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Color.fromARGB(255, 131, 146, 48)
        : Color(0xFF4B5320);
  }

  static Color amberColor(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Colors.amber
        : Color.fromARGB(255, 212, 157, 4);
  }

  static Color textColor(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Color(0xFFdfe0db)
        : Color(0xFF1a1a1a);
  }

  static Color textColorSecondary(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? Color(0xFFe0e0de)
        : Color(0xFF1c1c1c);
  }

  static String bkImg(BuildContext context) {
    return MediaQuery.of(context).platformBrightness == Brightness.dark
        ? camobkimg
        : lightcamobk;
  }
}

class NAGroups {
  int id;
  String groupName, photo;
  late NAUsers? createdBy;
  int userCount = 0;
  NAGroups(
      {required this.id,
      required this.photo,
      required this.groupName,
      this.createdBy,
      required this.userCount});
  factory NAGroups.fromJson(Map<String, dynamic> parsedJson) {
    return NAGroups(
        id: int.parse(parsedJson["id"].toString()),
        photo: parsedJson["photo"].toString() == ""
            ? "groups/ic_launcher_group.png"
            : parsedJson["photo"].toString(),
        groupName: parsedJson["group_name"],
        userCount: int.parse(parsedJson["user_count"].toString()));
  }
  setCreatedBy(NAUsers user) {
    createdBy = user;
  }

  setUserCount(int c) {
    userCount = c;
  }

  setGroupName(String str) {
    groupName = str;
  }

  setPhoto(String str) {
    photo = str;
  }
}

class NAUsers {
  String firstname, lastname, username, phone, photo, title;
  int id;
  bool isAdmin, status;

  NAUsers(
      {required this.photo,
      required this.isAdmin,
      required this.title,
      required this.firstname,
      required this.lastname,
      required this.username,
      required this.phone,
      required this.id,
      required this.status});
  factory NAUsers.fromJson(Map<String, dynamic> parsedJson) {
    return NAUsers(
        id: parsedJson["id"] != null
            ? int.parse(parsedJson["id"].toString())
            : 0,
        photo: parsedJson["photo"] != null
            ? parsedJson["photo"].toString()
            : "users/user.jpg",
        isAdmin: parsedJson["is_admin"] != null
            ? int.parse(parsedJson["is_admin"].toString()) == 1
                ? true
                : false
            : false,
        title:
            parsedJson["title"] != null ? parsedJson["title"].toString() : "",
        lastname: parsedJson["lastname"] != null
            ? parsedJson["lastname"].toString()
            : "Unknown",
        phone:
            parsedJson["phone"] != null ? parsedJson["phone"].toString() : "",
        username: parsedJson["username"] != null
            ? parsedJson["username"].toString()
            : "Deleted User",
        firstname: parsedJson["firstname"] != null
            ? parsedJson["firstname"].toString()
            : "Unknown",
        status: parsedJson["status"] != null
            ? int.parse(parsedJson["status"].toString()) == 1
                ? true
                : false
            : false);
  }

  Map<String, dynamic> toMap() {
    return {
      "photo": photo,
      "is_admin": isAdmin ? 1 : 0,
      "title": title,
      "firstname": firstname,
      "lastname": lastname,
      "username": username,
      "phone": phone,
      "id": id,
      "status": status ? 1 : 0
    };
  }

  void setAdmin(bool val) {
    isAdmin = val;
  }

  void setStatus(bool val) {
    status = val;
  }
}

String formatDate(DateTime timestamp) {
  var dt = timestamp;
  var diff = DateTime.now().difference(dt);
  var date = DateFormat('MMM d, ').format(dt) + DateFormat('jm').format(dt);
  var date2 = DateFormat('MMM d, y ').format(dt) + DateFormat('jm').format(dt);
  var date3 = DateFormat('EEE,').format(dt);

  if (diff.inDays >= 365) {
    var i = (diff.inDays / 365).round();
    if (i > 1) {
      date = i.toString() + " Years ago " + date2;
    } else {
      date = i.toString() + " Year ago " + date2;
    }
  } else if (diff.inDays > 30 && diff.inDays < 365) {
    var i = (diff.inDays / 30).round();
    if (i > 1) {
      date = i.toString() + " Months ago " + date;
    } else {
      date = i.toString() + " Month ago " + date;
    }
  } else if (diff.inDays > 6 && diff.inDays < 30) {
    var i = (diff.inDays / 7).round();
    if (i > 1) {
      date = i.toString() + " Weeks ago " + date;
    }
  } else if (diff.inDays > 0 && diff.inDays < 7) {
    var i = (diff.inDays).round();

    date = date3 + " " + DateFormat('jm').format(dt);
  } else if (diff.inHours > 0 && diff.inHours < 24) {
    var i = (diff.inHours).round();
    if (dt.day != DateTime.now().day) {
      date = "Yesterday, " + DateFormat('jm').format(dt);
    } else {
      date = DateFormat('jm').format(dt);
    }
  } else {
    var i = (diff.inMinutes).round();
    if (i > 1) {
      date = i.toString() + " Minutes ago";
    } else {
      date = i.toString() + " Minute ago";
    }
  }
  return date;
}
