import 'dart:convert';
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/material.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:hive/hive.dart';
import 'package:naim/classes/Auth.dart';
import 'dart:async';

import 'package:naim/classes/assets.dart';

import 'appdata.dart';

final greyColor = const Color(0xffe7e6e7);
final darkblueColor = const Color(0xff29338a);

class GUser {
  String fullname = "", phone = "", uid = "";
  Box<dynamic> naimBox = Hive.box('naim');

  final FirebaseAuth _firebaseAuth = FirebaseAuth.instance;

  Future<Map<String, dynamic>> loginUser(String phone) async {
    appData.dbUser = {};
    try {
      var dio = Dio();
      dio.options.baseUrl = appApi;
      var formData = {"phone": phone};
      var response = await dio.post(
        "login",
        data: formData,
        options: Options(
          method: 'POST',
          responseType: ResponseType.plain,
          headers: {
            HttpHeaders.contentLengthHeader:
                formData.length, // set content-length
          },
        ),
      );
      print(response.data);
      print("respnse data ======= ==");
      var data = json.decode(response.data);
      if (data["result"] != null) {
        if (data["result"] == "success") {
          appData.dbUser = data["data"];
          naimBox.put("token", appData.dbUser["token"]);
          return {"result": true};
        } else {
          return {"result": false, "msg": data["data"]["message"]};
        }
      }
    } catch (e) {
      print("Error: " + e.toString());
      return {"result": false, "msg": e.toString()};
    }
    return {"result": false, "msg": "Something went wrong"};
  }

  Future<Map<String, dynamic>> getCurrentUser() async {
    try {
      var user;
      //print("checking current users");
      //print(_firebaseAuth.currentUser);
      if (_firebaseAuth.currentUser == null) {
        // print("there is no auth");
        return {"user": null, "msg": "there is no auth"};
      }
      user = _firebaseAuth.currentUser;
      var b = await loginUser(user.phoneNumber);
      //var b = await loginUser("+2348029563955");
      // print("printing b =====");
      //print(b);
      if (!b["result"]) {
        return {"user": null, "msg": b["user"]};
      }
      //rint("it is the best of times ==== ");

      phone = user.phoneNumber;
      return {"user": user, "msg": ""};
    } catch (e) {
      //print("Error dea: " + e.toString());
      return {"user": null, "msg": e.toString()};
      ;
    }
  }

  Future<void> signOut() async {
    try {
      var dio = Dio();
      dio.options.baseUrl = appApi;
      var formData = {"token": appData.dbUser['token']};
      var response = await dio.post(
        "logout",
        data: formData,
        options: Options(
          method: 'POST',
          responseType: ResponseType.plain,
          headers: {
            HttpHeaders.contentLengthHeader:
                formData.length, // set content-length
          },
        ),
      );
      var data = json.decode(response.data);
      if (data["result"] != null) {
        if (data["result"] == "success") {
          appData.dbUser = data["data"];
          naimBox.put("token", "");
        }
      }
    } catch (e) {}
    appData.dbUser = {};
    return FirebaseAuth.instance.signOut();
  }
}
