import 'dart:async';
import 'dart:io';

import 'package:flutter/material.dart';
import './image_picker_dialog.dart';
import 'package:image_cropper/image_cropper.dart';
import 'package:image_picker/image_picker.dart';

class ImagePickerHandler {
  ImagePickerDialog? imagePicker;
  AnimationController? _controller;
  ImagePickerListener? _listener;
  ImagePicker _picker = new ImagePicker();
  ImagePickerHandler(this._listener, this._controller);

  bool bCrop = true;

  openCamera() async {
    imagePicker!.dismissDialog();
    var image = await _picker.getImage(source: ImageSource.camera);
    if (bCrop) {
      cropImage(File(image!.path));
    } else {
      _listener!.userImage(File(image!.path));
    }
  }

  openGallery() async {
    imagePicker!.dismissDialog();
    var image = await _picker.getImage(source: ImageSource.gallery);
    if (bCrop) {
      cropImage(File(image!.path));
    } else {
      _listener!.userImage(File(image!.path));
    }
  }

  void init(bool crop) {
    bCrop = crop;
    imagePicker = new ImagePickerDialog(this, _controller);
    imagePicker!.initState();
  }

  Future cropImage(File image) async {
    var im = ImageCropper();
    File? croppedFile = await im.cropImage(
      sourcePath: image.path,
      aspectRatio: CropAspectRatio(ratioX: 1.0, ratioY: 1.0),
      maxWidth: 512,
      maxHeight: 512,
    );
    _listener!.userImage(croppedFile!);
  }

  showDialog(BuildContext context) {
    imagePicker!.getImage(context);
  }
}

abstract class ImagePickerListener {
  userImage(File _image);
}
