import 'package:flutter/material.dart';

import 'misconduct.dart';

class SelectAgencyPage extends StatefulWidget {
  @override
  SelectAgencyPage(
    this.agent_type,
  );
  _SelectAgencyPageState createState() => _SelectAgencyPageState();

  final String agent_type;
}

class _SelectAgencyPageState extends State<SelectAgencyPage> {
  @override
  Widget build(BuildContext context) {
    List<dynamic> _listItem = [
      {
        "image": "assets/agencies/army.png",
        "text": "Nigerian Army",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage(
                      "Army", widget.agent_type, "assets/agencies/army.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/navy.png",
        "text": "Nigerian Navy",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage(
                      "Navy", widget.agent_type, "assets/agencies/navy.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/airforce.png",
        "text": "Nigerian Airforce",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("Airforce",
                      widget.agent_type, "assets/agencies/airforce.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/police.png",
        "text": "Nigerian Police",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("Police",
                      widget.agent_type, "assets/agencies/police.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/nscdc.png",
        "text": "NSCDC",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("NSCDC",
                      widget.agent_type, "assets/agencies/nscdc.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/dss.png",
        "text": "DSS",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage(
                      "DSS", widget.agent_type, "assets/agencies/dss.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/custom.png",
        "text": "Customs",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("CUSTOM",
                      widget.agent_type, "assets/agencies/custom.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/nimasa.png",
        "text": "NIMASA",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("NIMASA",
                      widget.agent_type, "assets/agencies/nimasa.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/frsc.png",
        "text": "Road Safety",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage(
                      "FRSC", widget.agent_type, "assets/agencies/frsc.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/ndlea.png",
        "text": "NDLEA",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("NDLEA",
                      widget.agent_type, "assets/agencies/ndlea.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/immi.png",
        "text": "Nigerian Immigration",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage("IMMIGRATION",
                      widget.agent_type, "assets/agencies/immi.png")));
          Navigator.of(context).pop();
        }
      },
      {
        "image": "assets/agencies/nema.png",
        "text": "NEMA",
        "route": () async {
          await Navigator.push(
              context,
              MaterialPageRoute(
                  builder: (context) => MisconductPage(
                      "NEMA", widget.agent_type, "assets/agencies/nema.png")));
          Navigator.of(context).pop();
        }
      }
    ];
    return Scaffold(
      backgroundColor: Colors.grey,
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        /*title: Text("Home"),
        actions: <Widget>[
          Padding(
            padding: EdgeInsets.all(10.0),
            child: Container(
              width: 36,
              height: 30,
              decoration: BoxDecoration(
                  color: Colors.grey[800],
                  borderRadius: BorderRadius.circular(10)),
              child: Center(child: Text("X")),
            ),
          )
        ],*/
      ),
      body: SafeArea(
        child: Container(
          padding: EdgeInsets.all(20.0),
          child: Column(
            children: <Widget>[
              Container(
                width: double.infinity,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(20),
                    image: DecorationImage(
                        image: AssetImage('assets/img/header.jpg'),
                        fit: BoxFit.cover)),
                child: Container(
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(20),
                      gradient:
                          LinearGradient(begin: Alignment.bottomRight, colors: [
                        Colors.black.withOpacity(.4),
                        Colors.black.withOpacity(.2),
                      ])),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: const <Widget>[
                      SizedBox(
                        height: 10,
                      ),
                      Text(
                        "Select Agency",
                        style: TextStyle(
                            color: Colors.white,
                            fontSize: 30,
                            fontWeight: FontWeight.bold),
                      ),
                      SizedBox(
                        height: 10,
                      )
                    ],
                  ),
                ),
              ),
              SizedBox(
                height: 20,
              ),
              Expanded(
                  child: GridView.count(
                crossAxisCount: 2,
                crossAxisSpacing: 10,
                mainAxisSpacing: 10,
                children: _listItem
                    .map((item) => Card(
                          color: Colors.transparent,
                          elevation: 0,
                          child: InkWell(
                            onTap: item['route'],
                            child: Container(
                              decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(20),
                                  image: const DecorationImage(
                                      image: AssetImage(
                                          "assets/img/header_dark.jpg"),
                                      fit: BoxFit.cover)),
                              child: Column(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: <Widget>[
                                  Container(
                                      width: 64.0,
                                      height: 64.0,
                                      decoration: BoxDecoration(
                                          shape: BoxShape.circle,
                                          image: DecorationImage(
                                              fit: BoxFit.fill,
                                              image:
                                                  AssetImage(item["image"])))),
                                  const SizedBox(height: 30),
                                  SizedBox(
                                      width: double.infinity,
                                      child: Text(
                                        item["text"],
                                        textAlign: TextAlign.center,
                                        style: const TextStyle(
                                            color: Colors.white,
                                            fontSize: 13,
                                            fontWeight: FontWeight.bold),
                                      )),
                                ],
                              ),
                            ),
                          ),
                        ))
                    .toList(),
              ))
            ],
          ),
        ),
      ),
    );
  }
}
