import 'dart:convert';
import 'dart:io';

import 'package:device_info/device_info.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:geolocator/geolocator.dart';

import 'crimereport.dart';
import 'widgets/input.dart';

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  final GeolocatorPlatform _geolocatorPlatform = GeolocatorPlatform.instance;
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.indigo.shade50,
      body: SafeArea(
        child: Container(
          margin: const EdgeInsets.only(top: 18, left: 24, right: 24),
          child: Column(
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: const [
                  Text(
                    "Welcome",
                    style: TextStyle(
                      fontSize: 18,
                      color: Colors.indigo,
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                  RotatedBox(
                    quarterTurns: 135,
                    child: Icon(
                      Icons.bar_chart_rounded,
                      size: 28,
                      color: Colors.indigo,
                    ),
                  ),
                ],
              ),
              Expanded(
                child: ListView(
                  physics: const BouncingScrollPhysics(),
                  children: [
                    const SizedBox(
                      height: 32,
                    ),
                    Center(
                      child: Image.asset(
                        "assets/images/beacon.png",
                        width: MediaQuery.of(context).size.width / 2,
                      ),
                    ),
                    const SizedBox(
                      height: 32,
                    ),
                    const Center(
                      child: Text(
                        "Counter Insurgency",
                        style: TextStyle(
                          fontSize: 32,
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                    ),
                    const SizedBox(height: 48),
                    const Text(
                      "SERVICES",
                      style:
                          TextStyle(fontSize: 14, fontWeight: FontWeight.bold),
                    ),
                    const SizedBox(
                      height: 16,
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        _cardMenu(
                            onTap: () {
                              Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                      builder: (context) => CrimeReportPage()));
                            },
                            title: "REPORT TREATS",
                            icon: "assets/images/energy.png"),
                        _cardMenu(
                          onTap: () {
                            submitEmergency();
                          },
                          title: "EMERGENCY",
                          icon: "assets/images/temperature.png",
                          fontColor: Colors.white,
                          color: Colors.green,
                        ),
                      ],
                    ),
                    const SizedBox(
                      height: 16,
                    )
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _cardMenu({
    required String title,
    required String icon,
    VoidCallback? onTap,
    Color color = Colors.white,
    Color fontColor = Colors.grey,
  }) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.symmetric(
          vertical: 36,
        ),
        width: 156,
        decoration: BoxDecoration(
          color: color,
          borderRadius: BorderRadius.circular(24),
        ),
        child: Column(
          children: [
            Image.asset(icon),
            const SizedBox(height: 10),
            Text(
              title,
              style: TextStyle(fontWeight: FontWeight.bold, color: fontColor),
            )
          ],
        ),
      ),
    );
  }

  Future<bool> _handlePermission() async {
    bool serviceEnabled;
    LocationPermission permission;

    // Test if location services are enabled.
    serviceEnabled = await _geolocatorPlatform.isLocationServiceEnabled();
    if (!serviceEnabled) {
      // Location services are not enabled don't continue
      // accessing the position and request users of the
      // App to enable the location services.
      showAlert(this.context, AlertDialogType.INFO, "Service Disabled",
          "Location Services are disabled. Please enable to continue");
      print("return  Service Disabled...");
      return false;
    }

    permission = await _geolocatorPlatform.checkPermission();

    if (permission == LocationPermission.denied) {
      permission = await _geolocatorPlatform.requestPermission();
      if (permission == LocationPermission.denied) {
        // Permissions are denied, next time you could try
        // requesting permissions again (this is also where
        // Android's shouldShowRequestPermissionRationale
        // returned true. According to Android guidelines
        // your App should show an explanatory UI now.
        showAlert(this.context, AlertDialogType.INFO, "Permission Denied",
            "Permission to Location Services where denied. Please allow to continue");
        print("return Permission Denied...");
        return false;
      }
    }

    if (permission == LocationPermission.deniedForever) {
      // Permissions are denied forever, handle appropriately.
      showAlert(this.context, AlertDialogType.INFO, "Permission Denied",
          "Permission to Location Services have been denied for this app. Please allow to continue");

      return false;
    }

    return true;
  }

  Future<Position> getCurrentPosition() async {
    final hasPermission = await _handlePermission();

    if (!hasPermission) {
      Position p = Position(
          longitude: 0,
          latitude: 0,
          timestamp: DateTime.now(),
          accuracy: 0,
          altitude: 0,
          heading: 0,
          speed: 0,
          speedAccuracy: 0);
      return p;
    }
    DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
    var isPhysical = true;
    if (Platform.isIOS) {
      IosDeviceInfo iosInfo = await deviceInfo.iosInfo;
      isPhysical = iosInfo.isPhysicalDevice;
    } else {
      AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
      isPhysical = androidInfo.isPhysicalDevice;
    }
    if (isPhysical) {
      final position = await _geolocatorPlatform.getCurrentPosition();
      return position;
    } else {
      var p = Position(
          longitude: 3.532,
          latitude: 4.342,
          timestamp: DateTime.now(),
          accuracy: 1,
          altitude: 1,
          heading: 0,
          speed: 0,
          speedAccuracy: 0);
      return p;
    }
  }

  submitEmergency() async {
    showAlert(this.context, AlertDialogType.INFO, "",
        "Sending your request, please do not tap again until after it completes");
    var pos = await getCurrentPosition();
    print("got postions.....");
    if (pos.altitude == 0 &&
        pos.speed == 0 &&
        pos.latitude == 0 &&
        pos.longitude == 0) {
      return;
    }

    try {
      var dio = new Dio();
      dio.options.baseUrl = appApi;
      print("attemping post.....");

      String device = "";
      DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
      if (Platform.isIOS) {
        IosDeviceInfo iosInfo = await deviceInfo.iosInfo;
        device = iosInfo.utsname.machine;
      } else {
        AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
        device = androidInfo.model;
      }

      var formData = {
        "sname": "MOBILE",
        "sphone": "",
        "email": "",
        "state": "",
        "file": "",
        "file_name": "",
        "address": "",
        "crimeType": "Armed Robbery",
        "report": "Emergency",
        "device": Platform.isIOS ? "ios" : "android",
        "os": Platform.isIOS ? "ios" : "android",
        "browser": device,
        "longitude": pos.longitude,
        "latitude": pos.latitude
      };
      print(dio.options.baseUrl + "crimereport/createcrimerport");
      var response = await dio.post(
        "crimereport/createcrimerport",
        data: json.encode(formData),
        options: Options(
          method: 'POST',
          responseType: ResponseType.plain,
          headers: {
            HttpHeaders.contentLengthHeader:
                formData.length, // set content-length
          },
        ),
      );
      print("Response status: ${response.statusCode}");

      var data = json.decode(response.data);

      if (data["result"] != null) {
        if (data["result"] == "success") {
          showDialog(
            context: this.context,
            builder: (BuildContext context) {
              return Material(
                  type: MaterialType.transparency,
                  child: Container(
                    alignment: Alignment.center,
                    child: Container(
                      margin: const EdgeInsets.all(8.0),
                      padding: const EdgeInsets.all(20.0),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(20.0),
                        color: Colors.white,
                      ),
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: <Widget>[
                          const SizedBox(height: 10.0),
                          const Icon(
                            Icons.check_circle,
                            color: Colors.green,
                            size: 50,
                          ),
                          const SizedBox(height: 10.0),
                          const Text(
                            "",
                            style: TextStyle(
                                fontSize: 20.0,
                                color: Colors.black,
                                fontWeight: FontWeight.bold),
                            textAlign: TextAlign.center,
                          ),
                          Divider(),
                          Text(
                            "Emergency Submitted",
                            textAlign: TextAlign.center,
                          ),
                          SizedBox(height: 40.0),
                          SizedBox(
                            width: double.infinity,
                            child: FlatButton(
                              padding: const EdgeInsets.all(5.0),
                              child: const Text("OK"),
                              onPressed: () {
                                Navigator.pop(context, true);
                              },
                            ),
                          ),
                        ],
                      ),
                    ),
                  ));
            },
          );
          //Navigator.of(this.context).pop();
        }
      }
      print('oh shit');
    } on DioError catch (e) {
      print(e.toString());
      print(e.message);
      print(e.response);
      //Navigator.push(this.context,MaterialPageRoute(builder: (context) => Htmlview(e.response!.data.toString())));
      showAlert(
          this.context, AlertDialogType.ERROR, "Oops", "Something went wrong");
    }
  }
}
