import 'dart:io';

import 'package:image/image.dart' as Img;

class StateModel {
  final String name;
  final String id;

  StateModel({required this.id, required this.name});

  factory StateModel.fromJson(Map<String, dynamic> json) {
    return StateModel(
      id: json["id"],
      name: json["name"],
    );
  }

  static List<StateModel> fromJsonList(List list) {
    return list.map((item) => StateModel.fromJson(item)).toList();
  }

  ///this method will prevent the override of toString
  String busAsString() {
    return '#${this.id} ${this.name}';
  }

  ///this method will prevent the override of toString
  bool? userFilterByName(String filter) {
    return this.name.contains(filter);
  }

  ///custom comparing function to check if two users are equal
  bool isEqual(StateModel? model) {
    return this.id == model?.id;
  }

  @override
  String toString() => name;
}

Future<List<int>> compressFile(File file) async {
  Img.Image? image_temp = Img.decodeImage(file.readAsBytesSync());
  if (image_temp!.width > 600) {
    Img.Image resized_img = Img.copyResize(image_temp, width: 600);
    return Img.encodePng(resized_img, level: 9);
  } else {
    return Img.encodePng(image_temp, level: 9);
  }
}
